#!/usr/bin/env python3

import os
import sys
try:
    import pefile
except ImportError:
    if 'CI' in os.environ:
        raise
    # Skip the test if not on CI
    sys.exit(77)

executable = sys.argv[1]
expected = int(sys.argv[2])

actual = pefile.PE(executable).dump_dict()['OPTIONAL_HEADER']['Subsystem']['Value']

print('subsystem expected: %d, actual: %d' % (expected, actual))
sys.exit(0 if (expected == actual) else 1)
